using System;
using System.Windows.Forms;
using System.ComponentModel;
using System.Collections;
using System.Diagnostics;

namespace gov.va.med.vbecs.GUI.controls
{


		#region Header

		///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
		///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/3/2002</CreationDate>
		///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
		///<summary>
		///Extended TextBox control with additional Barcode property.
		///</summary>

		#endregion

	public class BarcodeTextbox : System.Windows.Forms.TextBox
	{
        private BarcodeTextboxBase _barcodeTextboxBase;

		/// <summary>
		/// Required designer variable.
		/// </summary>
		protected System.ComponentModel.Container components = null;

		/// <summary>
		/// EventHandler for BarcodeChanged event
		/// </summary>
		public event EventHandler BarcodeChanged;

		/// <summary>
		/// Raises barcode indicator changed event
		/// </summary>
		protected virtual void OnBarcodeChanged()
		{
			if(BarcodeChanged != null)
				BarcodeChanged(this, EventArgs.Empty);
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/17/2002</CreationDate>
		///
		/// <summary>
		/// BarcodeTextbox control class constructor. Creates the instance of the control
		/// and adds it to the existing container.
		/// </summary>
		/// <param name="container"></param>
		public BarcodeTextbox(System.ComponentModel.IContainer container)
		{
			container.Add(this);
			InitializeComponent();
            InitBarcodeTextboxBase();
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/17/2002</CreationDate>
		/// <summary>
		/// BarcodeTextbox conrtrol class constructor. Creates the instance of the 
		/// control.
		/// </summary>
		public BarcodeTextbox()
		{
			InitializeComponent();
            InitBarcodeTextboxBase();
		}

        private void InitBarcodeTextboxBase()
        {
            _barcodeTextboxBase = new BarcodeTextboxBase();
        }


		#region Component Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			components = new System.ComponentModel.Container();
		}
		#endregion

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/3/2002</CreationDate>
		/// <summary>
		/// Barcode property. Returns true if entry was made by scanning a barcode.
		/// </summary>
		[
		Category("Behavior"),
		Description("Barcode"),
		Bindable(true),
		Browsable(true),
		]
		public bool Barcode
		{
			get
			{
                return this._barcodeTextboxBase.Barcode;
			}
			set
			{
                this._barcodeTextboxBase.Barcode = value;
				OnBarcodeChanged();
			}
		}

		/// <summary>
		/// Get/Set BarcodeType
		/// </summary>
		public Common.BarcodeType BarcodeType
		{
			get
			{
				return this._barcodeTextboxBase.BarcodeType;
			}
			set
			{
                this._barcodeTextboxBase.BarcodeType = value;
			}
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/13/2002</CreationDate>
		///
		/// <summary>
		/// Override for KeyPress event. Checks for ~ character which denotes a barcode was scanned.
		/// </summary>
		/// <param name="e"></param>
		protected override void OnKeyPress(KeyPressEventArgs e)
		{
			base.OnKeyPress(e);
            e.Handled = _barcodeTextboxBase.HandleKeyPress(this.SelectedText, this.Text, e.KeyChar);
		}


		/// <summary>
		/// Implements BR_1.04
		/// Handles the resetting of the barcode indicator to it's default state.
		/// </summary>
		/// <param name="e"></param>
		protected override void OnTextChanged(EventArgs e)
		{
            //string baseText = base.Text;
			base.OnTextChanged(e);
            _barcodeTextboxBase.OnTextChanged(base.Text);
		}
	}
}

